(defun spectrum (f0 r nmax)
(let ((l nil))
(do ((i nmax (1- i)))
((<= i 0)l)
(setq l(cons(* f0 r i)l)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun interp (a  r q  b)
 (list a b 
   (let((add 0))
     (dolist (x (spectrum 1 1 (+ r 1)) 'begin/end)
        (cond
           ((> q 1)
            (setq add (+(*(- q (*(/(- q (- 2 q))r)(- x 1))) (/(- b a)(+ r  1))) add)))
           ((< q 1)
            (setq add (+(*(+ q (*(/(- (- 2 q) q)r)( - x 1))) (/(- b a)(+ r 1))) add)))
           (( = q 1)
             (setq add (*(/(- b a)(+ r 1))x))))  
               (format t "  ~S"
                 (+ a add)
)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun jinterp (a  r q  b)
 (let ((toto nil))
(list a b 
   (let((add 0))
     (dolist (x (spectrum 1 1 (+ r 1)) 'begin/end)
        (cond
           ((> q 1)
            (setq add (+(*(- q (*(/(- q (- 2 q))r)(- x 1))) (/(- b a)(+ r  1))) add)))
           ((< q 1)
            (setq add (+(*(+ q (*(/(- (- 2 q) q)r)( - x 1))) (/(- b a)(+ r 1))) add)))
           (( = q 1)
             (setq add (*(/(- b a)(+ r 1))x))))                 
             (push(+ a add)toto))
))(reverse toto)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun interpol (a   r q  b)
  (format t "  ~S" a)
    (interp a  r q  b))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun jinterpol (a  r q  b)
  (cons a
  (jinterp a  r q  b)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(Defun Scopy (List1 List2 )
  (If (Null List1) Nil
  (If (Null List2) Nil
  (Append(List(Car List1)(Car List2))(Scopy (Cdr List1)(Cdr List2))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
(defun SScopy (list1 list2 nom-fichier)
  (if (null list1) NIL
      (if (null list2) NIL
          (append(list(format nom-fichier "~8F,"(car list1))
                      (format nom-fichier "~8F,"(car list2))
                      (SScopy (cdr list1)(cdr list2) nom-fichier))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun zcopy (lista listb)
  (if (null lista) NIL
  (if (null listb) NIL
  (cons(scopy(car lista)(car listb))
       (zcopy (cdr lista)(cdr listb))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(Defun ccopy (List nom-fichier)
  (If (Null List) Nil 
  (Append(List(format nom-fichier "~4F,"(Car List))              
              (ccopy (Cdr List)nom-fichier)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(Defun chhcopy ( Lista nom-fichier)
 (let ((lista-1 (reverse(cdr(reverse lista)))))
(If (Null Lista) Nil 
  (Append(List(format nom-fichier"kenv linseg ~4F," (Car Lista-1))              
              (ccopy (Cdr Lista-1)nom-fichier)
              (format nom-fichier"~4F~&"(car(reverse lista))))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(Defun cycopy (  List nom-fichier)
  (If (Null List) Nil 
  (cons(chhcopy  (Car List)nom-fichier)   
              (cycopy (Cdr List)nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(Defun lcopy (List nom-fichier)
  (If (Null List) Nil
  (Append(List(format nom-fichier "~8F,"(Car List))              
              (lcopy (Cdr List) nom-fichier)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(Defun lhhcopy ( q Lista nom-fichier)
 (let ((lista-1 (reverse(cdr(reverse lista)))))
   (If (Null Lista) Nil                 
       (append (list        
            (format nom-fichier " ~S ~8F," q (Car Lista-1))           
              (lcopy (Cdr Lista-1)nom-fichier)
              (format nom-fichier"~8F~&"(car(reverse lista)))
              )))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun pycopy ( list nom-fichier)
  (if(null list)nil
     (append(list(format nom-fichier"kenv~S "(car list))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(Defun lllcopy ( q Lista listb nom-fichier)
  (If (Null Lista) Nil 
  (If (Null Listb) Nil 
      (append(list
          (pycopy lista nom-fichier)              
          (cons (lhhcopy q (Car Listb)nom-fichier)              
             (lllcopy q (cdr lista)(Cdr Listb) nom-fichier)))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun addiz (n list)
  (if(null list)nil
    (cons (+ (- n 1)(car list))
          (addiz n(cdr list)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun xinterp (a  r q  b)
 (list a b 
   (let((add 0))
     (dolist (x (spectrum 1 1 (+ r 1))'begin/end)
        (cond
           ((> q 1)
            (setq add (*(- q (*(/(- q (- 2 q))r)(- x 1))) (/(- b a)(+ r  1)))))
           ((< q 1)
            (setq add (*(+ q (*(/(- (- 2 q) q)r)( - x 1))) (/(- b a)(+ r 1)))))
           (( = q 1)
             (setq add (/(- b a)(+ r 1)))))   
        (format t "  ~S"
                (cond
                 ((>= b a)
                 add)
                 ((< b a)
                  (- (- add  add )add)))
)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun xjinterp (a  r q  b)
  (let ((toto nil)) 
   (list a b 
         (let((add 0))
           (dolist (x (spectrum 1 1 (+ r 1))'begin/end)
             (cond
              ((> q 1)
               (setq add (*(- q (*(/(- q (- 2 q))r)(- x 1))) (/(- b a)(+ r  1)))))
              ((< q 1)
               (setq add (*(+ q (*(/(- (- 2 q) q)r)( - x 1))) (/(- b a)(+ r 1)))))
              (( = q 1)
               (setq add (/(- b a)(+ r 1)))))   
             (push
              (cond
               ((>= b a)
                add)
               ((< b a)
                (- (- add  add )add)))toto)
)))(reverse toto)
))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(Defun wcopy (List1 List2 )
  (let ((x
         (if (null list1)nil
             (Append(List(Car List1)(Car List2))
                    (wcopy (Cdr List1)(Cdr List2))))))
    (remove  nil x)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
(defun zwcopy (lista listb)
  (if (null lista) NIL
  (if (null listb) NIL
  (cons(wcopy(car lista)(car listb))
       (zwcopy (cdr lista)(cdr listb))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; INTERPOLAZIONE SEMPLICE TRA DUE O PIU' VALORI (ADDIZIONE DI VALORI)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun qinterp (list1 list2 list3) 
  (if (null list1)NIL
           (if (null list2)NIL
               (if (null list3)NIL
                   (append(jinterp (car list1)(car list2)(car list3)(car(cdr list1)))
                          (qinterp (cdr list1)(cdr list2)(cdr list3)))
))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;                
(defun interplus (lfreq letapes lcoeff)
  (cons (car lfreq)
        ( qinterp lfreq letapes lcoeff)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun qinterp0 (list1 rk qk) 
  (if (null (cdr list1))NIL
                   (append(jinterp (car list1)rk qk (car(cdr list1)))
                          (qinterp0 (cdr list1)rk qk))
))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;                
(defun interplus0 (list1 rk qk)
  (cons (car list1)
        ( qinterp0 list1 rk qk)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;INTERPOLAZIONE COMPLESSA TRA DUE LISTE DI VALORI (ADDIZIONE DI VALORI)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun casscopy (lista)
  (if (null lista)nil
      (cons
       (cdr (car lista))
       (casscopy(cdr lista)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun carcopy (lista)
  (if (null lista)nil
      (cons (car(car lista))
            (carcopy(cdr lista)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun popcopy (lista)
  (if (null (car lista))nil
      (cons
       (carcopy lista)
       (popcopy(casscopy lista)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun qinterpxx1 (list1 r q) 
  (if (null list1)NIL          
          (cons(jinterpol (car list1) r q (car(cdr list1)))
               (qinterpxx1 (cdr(cdr list1)) r q))
))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun qinterpxx1/2 (list1 r q) 
  (if (null list1)NIL          
          (cons(jinterp (car list1) r q (car(cdr list1)))
               (qinterpxx1/2 (cdr(cdr list1)) r q))
))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun qinterpxx2 (list1 r list2) 
  (if (null list1)NIL
      (if (null list2)NIL               
          (cons(jinterpol (car list1) r (car list2)(car(cdr list1)))
               (qinterpxx2 (cdr(cdr list1)) r (cdr list2)))
)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun interpmax0 (list1 list2 rk qk r q)
  (popcopy(qinterpxx1
           (scopy(interplus0 list1 rk qk)
                 (interplus0 list2 rk qk))
           r q)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun interpmax1 (list1 list2 list3 list4 r q)
  (popcopy(qinterpxx1
           (scopy(interplus list1 list3 list4)
                 (interplus list2 list3 list4))
           r q)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun interpmax2 (list1 list2 list3 list4 r list5)
  (popcopy(qinterpxx2
           (scopy(interplus list1 list3 list4)
                 (interplus list2 list3 list4))
           r list5)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;INTERPOLAZIONE SEMPLICE TRA DUE O PIU' VALORI  (DIFFERENZA DI VALORI)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kqinterp (list1 list2 list3) 
  (if (null list1)NIL
           (if (null list2)NIL
               (if (null list3)NIL
                   (append(xjinterp (car list1)(car list2)(car list3)(car(cdr list1)))
                          (kqinterp (cdr list1)(cdr list2)(cdr list3)))
))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kqinterp0 (list1 rk qk) 
  (if (null(cdr list1))NIL
                   (append(xjinterp (car list1)rk qk(car(cdr list1)))
                          (kqinterp0 (cdr list1)rk qk))
))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;INTERPOLAZIONE COMPLESSA TRA DUE LISTE DI VALORI (DIFFERENZA DI VALORI)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kqinterpxx1 (list1 r q) 
  (if (null list1)NIL                    
          (cons(xjinterp (car list1) r q (car(cdr list1)))
               (kqinterpxx1 (cdr(cdr list1)) r q))
))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kqinterpxx1/2 (list1 r q) 
  (if (null list1)NIL                    
          (cons(xjinterp (car list1) r q (car(cdr list1)))
               (kqinterpxx1/2 (cdr(cdr list1)) r q))
))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kqinterpxx2 (list1 r list2) 
  (if (null list1)NIL
      (if (null list2)NIL               
          (cons(jinterpol (car list1) r (car list2)(car(cdr list1)))
               (kqinterpxx2 (cdr(cdr list1)) r (cdr list2)))
)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kinterpmax0 (list1 list2 rk qk r q)
(popcopy (qinterpxx1
       (scopy(kqinterp0 list1 rk qk)
             (kqinterp0 list2 rk qk))
           r q)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kinterpmax1 (list1 list2 list3 list4 r q)
(popcopy (kqinterpxx1
       (scopy(kqinterp list1 list3 list4)
             (kqinterp list2 list3 list4))
           r q)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kinterpmax2 (list1 list2 list3 list4 r list5)
(popcopy (kqinterpxx2
       (scopy(kqinterp list1 list3 list4)
             (kqinterp list2 list3 list4))
           r list5)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;INTERPOLAZIONE SEMPLICE VALORE-TEMPO(CREAZIONE DI UN INVILUPPO)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun interpline0 (k n q list1  r q1  list2  q2  nom-fichier )
  (let((listx(interplus0  list1 r q1)))
    (let((listy(kqinterp0 list2 r q2)))
    (if (null listx) nil
        (if (null listy) nil
          (append(list 
                    (format nom-fichier "~S~S  ~S ~8F,"k n q(car listx))           
                    (format nom-fichier "~8F,"(car listy))
                    (SScopy (cdr listx)(cdr listy) nom-fichier)
                    (format nom-fichier "~8F ~%~%"(car(reverse listx)))             
                    )))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun endinterpline0 (k n q list1  r q1  list2  q2  nom-fichier )
  (let((listx(interplus0  list1 r q1)))
    (let((listy(kqinterp0 list2 r q2)))
    (if (null listx) nil
        (if (null listy) nil
          (append(list 
                    (format nom-fichier "~S~S  ~S ~8F,"k n q (car listx))           
                    (format nom-fichier "~8F,"(car listy))
                    (SScopy (cdr listx)(cdr listy) nom-fichier)
                    (format nom-fichier "~8F,.01,0.00001~%~%"(car(reverse listx)))             
                    )))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun interpline (k n q list1 list2 list3   list4  list5  nom-fichier )
  (let((listx(interplus  list1 list2 list3)))
    (let((listy(kqinterp list4 list2 list5)))
    (if (null listx) nil
        (if (null listy) nil
          (append(list
                    (format nom-fichier "~S~S ~S ~8F,"k n q (car listx))           
                    (format nom-fichier "~8F,"(car listy))
                    (SScopy (cdr listx)(cdr listy) nom-fichier)
                    (format nom-fichier "~8F ~%~%"(car(reverse listx)))             
                    )))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;INTERPOLAZIONE COMPLESSA VALORE-TEMPO(CREAZIONE DI DUE O PIU' INVILUPPI)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kcopy (k list nom-fichier)
  (if(null list)nil
     (append(list(format nom-fichier"~S~S "k (car list))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(Defun xxxcopy (k q  Lista listb nom-fichier)
  (If (Null Lista) Nil 
  (If (Null Listb) Nil 
      (append(list
          (kcopy k lista nom-fichier)              
          (cons (lhhcopy q (Car Listb)nom-fichier)              
             (xxxcopy k q (cdr lista)(Cdr Listb) nom-fichier)))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(Defun endlhhcopy ( q Lista nom-fichier)
 (let ((lista-1 (reverse(cdr(reverse lista)))))
   (If (Null Lista) Nil                 
       (append (list        
            (format nom-fichier " ~S ~8F," q (Car Lista-1))           
              (lcopy (Cdr Lista-1)nom-fichier)
              (format nom-fichier"~8F,.01,0.00001~&"(car(reverse lista)))
              )))))                                                     
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(Defun endxxxcopy (k q Lista listb nom-fichier)
  (If (Null Lista) Nil 
  (If (Null Listb) Nil 
      (append(list
          (kcopy k lista nom-fichier)              
          (cons (endlhhcopy q (Car Listb)nom-fichier)              
             (endxxxcopy k q (cdr lista)(Cdr Listb) nom-fichier)))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun env0 (k n q list1 list2 rk qk1   r q1
                    list6 list7 qk2 q2 nom-fichier)
  (let((bbb
   (let((lista(reverse(cdr(reverse(interpmax0 list1 list2 rk qk1 r q1))))))
    (let((listb(reverse (cdr(reverse(kinterpmax0 list6 list7 rk qk2 r q2))))))
       (if (null lista) nil
        (if (null listb) nil
        (cons 
       (wcopy (car lista) (car listb))  
       (zwcopy (cdr lista) (cdr listb))                                                        
       )))))))
 (endxxxcopy  k q (addiz n (spectrum 1 1 (+ r 2))) bbb  nom-fichier)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun env1 (k n q list1 list2 list3 list4 r q1
                    list6 list7 list8 q2 nom-fichier)
  (let((bbb
   (let((lista(interpmax1 list1 list2 list3 list4 r q1)))
    (let((listb (kinterpmax1 list6 list7 list3 list8 r q2)))
       (if (null lista) nil
        (if (null listb) nil
        (cons 
       (wcopy (car lista) (car listb))  
       (zwcopy (cdr lista) (cdr listb))                                                        
       )))))))
 (xxxcopy  k q (addiz n (spectrum 1 1 (+ r 2))) bbb  nom-fichier)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun env2 (k n q list1 list2 list3 list4 r list5 
                    list6 list7 list8 list9 nom-fichier)
  (let((bbb
   (let((lista(interpmax2 list1 list2 list3 list4 r list5)))
    (let((listb (kinterpmax2 list6 list7 list3 list8 r list9)))
       (if (null lista) nil
        (if (null listb) nil
        (cons 
       (wcopy (car lista) (car listb))  
       (zwcopy (cdr lista) (cdr listb))                                                        
       )))))))
 (xxxcopy  k q (addiz n (spectrum 1 1 (+ r 2))) bbb  nom-fichier)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun molt (lista x)
  (if (null lista)nil
  (cons(*(car lista) x)
       (molt (cdr lista )x))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun superenv (k q list1 list2 list3 rk list4 list5 list6 list7 nom-fichier)
  (if (null (cdr list3)) nil
      (list  (env0 k  (car list1) q (molt list2 (car list3)) (molt list2(car(cdr list3)))
         rk (car list4) (- (car(cdr list1))(car list1) 1) (car list5)
             list6 list6 (car list7) 1  nom-fichier)
             (superenv k q (cdr list1 ) list2(cdr list3) rk (cdr list4)
                       (cdr list5) list6 (cdr list7) nom-fichier)
)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun superenvelope (k q list1 list2 list3 rk list4 list5 list6 list7 nom-fichier)
  (list
   ( superenv k q list1 list2 list3 rk list4 list5 list6 list7 nom-fichier)
   (interpline0 k 
               (car(reverse list1)) q
                   (molt list2 (car(reverse list3)))
                   rk (car(reverse list4))
                   list6 (car(reverse list7)) nom-fichier)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun iperenv  (k q list1 list2 list3  rk list4 list5 
                         list6 list7     list8 list9 nom-fichier)
  (if (null (cdr list3)) nil
      (list  (env0 k (car list1) q (molt list2 (car list3)) (molt list2(car(cdr list3)))
         rk (car list4) (- (car(cdr list1))(car list1) 1) (car list5)
             (molt list6 (car list7)) (molt list6 (car (cdr list7)))  (car list8) (car list9)   nom-fichier)
             (iperenv k q (cdr list1) list2(cdr list3) rk (cdr list4)
                       (cdr list5) list6 (cdr list7) (cdr list8) (cdr list9) nom-fichier)
)))             
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun iperenvelope (k q list1 list2 list3 rk list4 list5 
                             list6 list7    list8 list9 nom-fichier)
  (list
   ( iperenv k q list1 list2 list3 rk list4 list5 list6 list7 list8 list9 nom-fichier)
   (endinterpline0 k 
               (car(reverse list1)) q
                   (molt list2 (car(reverse list3)))
                   rk (car(reverse list4))
                   (molt list6 (car(reverse list7))) (car(reverse list8)) nom-fichier)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun line (k n q list1 list2  nom-fichier )
  (let((listx(interplus0  list1 0 1)))
    (let((listy(kqinterp0 list2 0 1)))
    (if (null listx) nil
        (if (null listy) nil
          (append(list 
                    (format nom-fichier "~%~S~S ~S ~8F,"k n q (car listx))           
                    (format nom-fichier "~8F,"(car listy))
                    (SScopy (cdr listx)(cdr listy) nom-fichier)
                    (format nom-fichier "~8F"(car(reverse listx)))             
                    )))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun linend (k n q list1   list2  nom-fichier )
  (let((listx(interplus0  list1 0 1)))
    (let((listy(kqinterp0 list2 0 1)))
    (if (null listx) nil
        (if (null listy) nil
          (append(list 
                    (format nom-fichier "~%~S~S ~S ~8F,"k n q (car listx))           
                    (format nom-fichier "~8F,"(car listy))
                    (SScopy (cdr listx)(cdr listy) nom-fichier)
                    (format nom-fichier "~8F, .01,0.00001"(car(reverse listx)))             
                    )))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun interpmin (list1 list2 r q)
  (popcopy (qinterpxx1
           (scopy(interplus0 list1 0 1)
                 (interplus0 list2 0 1))
           r q)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kinterpmin (list1 list2 r q)
(popcopy (qinterpxx1
       (scopy(kqinterp0 list1 0 1)
             (kqinterp0 list2 0 1))
           r q)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun qenv0 (k n q list1 list2  r  q1
                    list6 list7  q2 nom-fichier)
  (let((bbb
   (let((lista(reverse(cdr(reverse(interpmin list1 list2  r q1))))))
    (let((listb(reverse (cdr(reverse(kinterpmin list6 list7 r q2))))))
       (if (null lista) nil
        (if (null listb) nil
        (cons 
       (wcopy (car lista) (car listb))  
       (zwcopy (cdr lista) (cdr listb))                                                        
       )))))))
 (xxxcopy  k q (addiz n (spectrum 1 1 (+ r 2))) bbb  nom-fichier)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun endqenv0 (k n q list1 list2  r  q1
                    list6 list7  q2 nom-fichier)
  (let((bbb
   (let((lista(reverse(cdr(reverse(interpmin list1 list2  r q1))))))
    (let((listb(reverse (cdr(reverse(kinterpmin list6 list7 r q2))))))
       (if (null lista) nil
        (if (null listb) nil
        (cons 
       (wcopy (car lista) (car listb))  
       (zwcopy (cdr lista) (cdr listb))                                                        
       )))))))
 (endxxxcopy  k q (addiz n (spectrum 1 1 (+ r 2))) bbb  nom-fichier)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun superqenv (k q list1 list2 list3 list4 list5  nom-fichier)
  (if (null (cdr list3)) nil
      (list  (qenv0 k (car list1) q (molt list2 (car list3)) (molt list2(car(cdr list3)))
           (- (car(cdr list1))(car list1) 1) (car list4)
             list5 list5  1  nom-fichier)
             (superqenv k q (cdr list1 ) list2 (cdr list3)
                       (cdr list4) list5  nom-fichier)
)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun superqenvelope (k q list1 list2 list3 list4 list5  nom-fichier)
  (list (format nom-fichier "~%")
   ( superqenv k q list1 list2 list3  list4 list5  nom-fichier)
   (interpline0 k 
               (car(reverse list1)) q
                   (molt list2 (car(reverse list3)))
                   0 1
                   list5 1 nom-fichier)))                  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun iperqenv (k q list1 list2 list3 list4 list5 list6 list7 nom-fichier)
  (if (null (cdr list3)) nil
      (list  (endqenv0 k (car list1) q (molt list2 (car list3)) (molt list2(car(cdr list3)))
           (- (car(cdr list1))(car list1) 1) (car list4)
             (molt list5 (car list6)) (molt list5 (car(cdr list6))) (car list7)  nom-fichier)
             (iperqenv k q (cdr list1 ) list2 (cdr list3)
                       (cdr list4) list5  (cdr list6) (cdr list7) nom-fichier)
)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun iperqenvelope (k q list1 list2 list3 list4 list5 list6 list7  nom-fichier)
  (list
   ( iperqenv k q list1 list2 list3  list4 list5 list6 list7 nom-fichier)
   (endinterpline0 k 
               (car(reverse list1)) q
                   (molt list2 (car(reverse list3)))
                   0 1
                   (molt list5 (car(reverse list6)))
                   (car(reverse list7)) nom-fichier)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;MOLTIPLICAZIONE-ADDIZIONE-SOTTRAZIONE DI LISTE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun chorus (lista listb)
  (if (null lista ) NIL
   (append(molt   listb (car lista))
         (chorus (cdr lista ) listb))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;     
(defun summa(n list)
  (if(null list)nil
    (cons (+ n (car list))
          (summa n (cdr list)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun sott(n list)
  (if(null list)nil
    (cons (- (car list) n)
          (sott n (cdr list)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun sumplus (lista listb)
  (if (null listb ) NIL
   (append(summa  (car listb) lista)
         (sumplus  lista  (cdr  listb)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun sotplus (lista listb)
  (if (null listb ) NIL
   (append(sott  (car listb) lista)
         (sotplus  lista  (cdr  listb)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;INIZIO ORCHESTRA
(defun enter (x1 x2 x3  nom-fichier)
  (append 
           (format  nom-fichier " ~%sr = ~S" x1)
           (format  nom-fichier " ~%kr = ~S" x2)
           (format  nom-fichier " ~%ksmps = ~S" (/ x1 x2))
           (format  nom-fichier " ~%nchnls = ~S ~%~%~%" x3)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun ninstr (x1 x2 x3 nom-fichier)
  (append (format  nom-fichier "~%~%instr ~S" x1 )
          (format  nom-fichier " ~%iscaling=32767/(~S*~S)~%~%" x2 x3)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;ELENCO OSCILLATORI
(defun oscilix (lista listb nom-fichier)
  (if (null lista)nil
      (append
       (format nom-fichier "~%a~S oscili "(car lista))
       (format nom-fichier "kenv~S*iscaling,"(car lista))
       (format nom-fichier "~8F+kvib+kjitter,1"(car listb))
(oscilix (cdr lista)(cdr listb)nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun oscili (lista nom-fichier)
  (oscilix (spectrum 1 1 (length lista)) lista nom-fichier))
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;ELENCO OSCILLATORI CON P4 E P5
(defun osciliP (lista listb nom-fichier)
  (if (null lista)nil
      (append
       (format nom-fichier "~%a~S oscili "(car lista))
       (format nom-fichier "p5 * (kenv~S*iscaling),"(car lista))
       (format nom-fichier "(p4 * ~8F)+kvib+kjitter,1"(car listb))
(osciliP (cdr lista)(cdr listb)nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun PXoscili (lista nom-fichier)
  (oscilip (spectrum 1 1 (length lista)) lista nom-fichier))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;FINE ORCHESTRA
(defun aout1  (lista y nom-fichier)
  (if (null lista)nil
      (append 
       ( format  nom-fichier "+a~S" (+(car lista) y))
       (aout1 (cdr lista) y  nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun acopy(x  listb y  nom-fichier)
  (if (null listb)nil
  (append (format  nom-fichier "~%aout~S=0.0" x)        
         (aout1  (spectrum 1 1 (car listb)) y  nom-fichier)
         (acopy (+ 1 x) (cdr listb) (+ y (car listb)) nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
(defun exit (k lista  nom-fichier)
  (if( null lista)nil
     (append
      (acopy 1 lista 0  nom-fichier)     
        (format  nom-fichier"~%~%asortie1=0.0") 
        (dolist (x(spectrum 1 1 (length lista))nil)
          (format  nom-fichier "+aout~S"x))
        (format  nom-fichier "~%~S   (0.0+asortie1)~%endin"k))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;VIBRATO
(defun vibr (q list1 list2 list3 nom-fichier)
 (append
  (line 'kprof 1 q list1 list3 nom-fichier)
  (line 'kvit 1 q list2 list3 nom-fichier)
  (format nom-fichier "kvib oscili kprof1,kvit1,1~%~%")))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun vibralea (q x list1  y list2  list3  list4  nom-fichier)
 (append
  (format nom-fichier "~%kalea1 randi ~S,~S~%"(nth 0 list4)(nth 1 list4))
  (format nom-fichier"kalea2 randi ~S,~S~%"(nth 2 list4)(nth 3 list4))
  (line 'kprof 1 q (molt list1 x)list3 nom-fichier)
  (line 'kvit 1 q (molt list2 y)list3 nom-fichier)
  (format nom-fichier "~%kvib oscili kprof1+(kprof1*kalea1),kvit1+(kvit1*kalea2),1~%~%")))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun vibr+ (n  nom-fichier)      
      (append
       (dolist (x(spectrum 1 1 n)nil)
       (format nom-fichier "~%kvib~S oscili "x)
       (format nom-fichier "kprof~S,"x)
       (format nom-fichier "kvit~S,~1~%"x)
      )))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;JITTER
(defun jitter (q list1 list2 list3 nom-fichier)
 (append
  (line 'khalfbd 1 q list1 list3 nom-fichier)
  (line 'ktimes  1 q list2 list3 nom-fichier)
  (format nom-fichier "kjitter randi khalfbd1,ktimes1~%")))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun jitterplusx(x list1 nom-fichier)
 (if (null list1)nil
  (append   
   (format nom-fichier "kjitter~S randi ~S,~S~%"x (nth 0 list1)(nth 1 list1))
   (jitterplusx (+ x 1) (cdr(cdr list1)) nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun jitterplus ( list1 nom-fichier)
  (append  
   (jitterplusx 1 list1 nom-fichier)
   (format nom-fichier "kjitter=0.0")
  (dolist (x(spectrum 1 1 (/(length list1)2)) nil)
    (format nom-fichier "+kjitter~S" x ))
  (format nom-fichier "~%" )))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun jitter+ (n  nom-fichier)      
      (append
       (dolist (x(spectrum 1 1 n)nil)      
         (format nom-fichier "~%kjitter~S randi"x)
         (format nom-fichier "khalfbd~S,"x)
         (format nom-fichier "ktimes~S~%"x)
      )))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;BRUIT ,FONTI PERIODICHE E FILTRI
(defun abruit (q list1 list2 list3 nom-fichier)
 (append
  (line 'khalfbd 1 q list1 list3 nom-fichier)
  (line 'ktimes  1 q list2 list3 nom-fichier)
  (format nom-fichier "~%aimpuls randi khalfbd1,ktimes1~%")))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun aperiod (q list1 list2 f nom-fichier)
  (if(null list1)NIL
  (append   (line 'kenv 1 q list1 list2 nom-fichier)
     (format nom-fichier "~%aimpuls oscili kenv1,~8F,2~%" f))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun resonx (lista listb listc nom-fichier)
  (if (null lista)nil
      (append
       (format nom-fichier "~%a~S reson "(car lista))
       (format nom-fichier "(aimpuls*~8F)*iscaling,~8F,"(car listb)(car listc))
       (format nom-fichier "kband~S+(kband~S*kbalea)"(car lista)(car lista))
(resonx (cdr lista)(cdr listb)(cdr listc)nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun reson (lista listb listc nom-fichier)
  (append  
   (format nom-fichier "~%kbalea randi ~S,~S~% "(nth 0 listc)(nth 1 listc))
   (resonx (spectrum 1 1 (length lista)) lista listb nom-fichier)))
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun x*l (lista listb)
  (if (null lista ) NIL
   (cons(molt   listb (car lista))
         (x*l  (cdr lista ) listb))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;FORMANTI PER SINTESI ADDITIVA
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun   formantx (lista listb listc nom-fichier)
  (if (null lista)nil
      (append
       (format nom-fichier "~%aformant~S reson "(car lista))
       (format nom-fichier "(asortie1*~8F)*iscaling,~8F,"(car listb)(car listc))
       (format nom-fichier "kband~S+(kband~S*kbalea)"(car lista)(car lista))
(formantx (cdr lista)(cdr listb)(cdr listc)nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun formant (lista listb listc nom-fichier)
  (append  
   (format nom-fichier "~%kbalea randi ~S,~S~% "(nth 0 listc)(nth 1 listc))
   (formantx (spectrum 1 1 (length lista)) lista listb nom-fichier)))
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun  kformantx (lista listb nom-fichier)
  (if (null lista)nil
      (append
       (format nom-fichier "~%aformant~S reson "(car lista))
       (format nom-fichier "(asortie1*~8F)*iscaling,kgliss~S,"(car listb)(car lista))
       (format nom-fichier "kband~S+(kband~S*kbalea)"(car lista)(car lista))
(kformantx (cdr lista)(cdr listb)nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kformant (lista listb  nom-fichier)
  (append  
   (format nom-fichier "~%kbalea randi ~S,~S~% "(nth 0 listb)(nth 1 listb))
   (kformantx (spectrum 1 1 (length lista)) lista  nom-fichier)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun choose (x lista)
              (if(null  lista) nil 
               (cons(nth x(car lista)) 
                    (choose x (cdr lista)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  
(defun kbandx (k x q listn lista listb nom-fichier)
(if (null listn) nil
  (append 
   (line k (car listn)  q  (choose x lista) listb nom-fichier)
    (kbandx k (+ 1 x) q  (cdr listn) lista listb nom-fichier)
    )))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kelenc (q lista listb listc nom-fichier)
  (if (null lista)nil
      (append
       (kbandx 'kgliss 0 q (spectrum 1 1 (length (car lista))) lista listc nom-fichier)
       (kbandx 'kband 0 q (spectrum 1 1 (length (car lista))) listb listc nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;RM
(defun RMoscilix (lista listb nom-fichier)
  (if (null lista)nil
      (append
       (format nom-fichier "~%a~S oscili "(car lista))
       (format nom-fichier "a0+(kenv1*iscaling),~7F+kvib+kjitter,1"(car listb))
(RMoscilix (cdr lista)(cdr listb)nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun RMoscili (lista nom-fichier)
  (rmoscilix (spectrum 1 1 (length lista)) lista nom-fichier))
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun RM (lista listb listc nom-fichier)
           (if (null lista)NIL
           (append         
            (line 'kgliss 1 listb listc nom-fichier)
            (format nom-fichier "a0 oscili kenv1*iscaling,kgliss1,1")
            (RMoscili lista nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun modamx (lista listb listc nom-fichier)
  (if (null lista)nil
      (append
       (format nom-fichier "~%am~S oscili "(car lista))
       (format nom-fichier "kenv0,"(car lista))
       (format nom-fichier "~7F,1"(-(* (car listb)(car listc))(car listb)))
       (modamx(cdr lista)(cdr listb)(cdr listc)nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun modam (lista listb nom-fichier)
  (modamx (spectrum 1 1 (length lista)) lista listb nom-fichier))
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun am (lista listb nom-fichier)
 (append (oscili lista nom-fichier)
         (modam lista listb nom-fichier)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;FINE ORCHESTRA AM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun amout1  (lista y nom-fichier)
  (if (null lista)nil
      (append 
       ( format  nom-fichier "+a~S+(a~S*am~S)" (+(car lista) y)(+(car lista)y)(+(car lista)y))
       (amout1 (cdr lista) y  nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun amcopy(x  listb y  nom-fichier)
  (if (null listb)nil
  (append (format  nom-fichier "~%aout~S=0.0" x)        
         (amout1  (spectrum 1 1 (car listb)) y  nom-fichier)
         (amcopy (+ 1 x) (cdr listb) (+ y (car listb)) nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
(defun amexit (k lista  nom-fichier)
  (if( null lista)nil
     (append
      (amcopy 1 lista 0  nom-fichier)     
        (format  nom-fichier"~%~%asortie1=0.0") 
        (dolist (x(spectrum 1 1 (length lista))nil)
          (format  nom-fichier "+aout~S"x))
        (format  nom-fichier "~%~S   (0.0+asortie1)~%endin"k))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;FM
(defun foscilix (lista listb nom-fichier)
  (if (null lista)nil
      (append
       (format nom-fichier "~%a~S foscili "(car lista))
       (format nom-fichier "kenv~S*iscaling,"(car lista))
       (format nom-fichier "1,kport~S,kport~S*~8F,kindex1,1"
               (car lista)(car lista)(car listb))
(foscilix (cdr lista)(cdr listb)nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun foscili (lista  nom-fichier)
  (foscilix (spectrum 1 1 (length lista)) lista nom-fichier))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;FORMANTI E FINE ORCHESTRA PER SINT ADD + FOMANTI
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun formantexit (lista listb listc k listout  nf nom-fichier)
  (if( null lista)nil
     (append
      (acopy 1 listout 0  nom-fichier)
        (format  nom-fichier"~%~%asortie1=0.0")           
        (dolist (x(spectrum 1 1 (length listout))nil)
          (format  nom-fichier "+aout~S"x))
        (formant lista listb listc nom-fichier)
        (format  nom-fichier"~%~%asortie2=0.0") 
        (dolist (x(spectrum 1 1 nf)nil)
          (format  nom-fichier "+aformant~S"x))     
        (format  nom-fichier "~%~S   (0.0+asortie1+asortie2)~%endin"k))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kformantexit (lista listb  k listout  nf nom-fichier)
  (if( null lista)nil
     (append
      (acopy 1 listout 0  nom-fichier)
        (format  nom-fichier"~%~%asortie1=0.0")           
        (dolist (x(spectrum 1 1 (length listout))nil)
          (format  nom-fichier "+aout~S"x))
        (kformant lista listb  nom-fichier)
        (format  nom-fichier"~%~%asortie2=0.0") 
        (dolist (x(spectrum 1 1 nf)nil)
          (format  nom-fichier "+aformant~S"x))     
        (format  nom-fichier "~%~S   (0.0+asortie1+asortie2)~%endin"k))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DUPLICAZIONE DI LISTE
(defun  du (lista)
 (if (null lista)nil
     (append(list(car lista)(car lista))
          (du (cdr lista)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;RIPETIZIONE DELLO STESSO VALORE
(defun idem (x ntimes)
  (jinterpol x (- ntimes 2) 1 x))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DEFINIZIONE SCORE COMPLESSO
(defun scoresa (x  lista nom-fichier)
 (if (null  lista)nil
  (append  
 (format nom-fichier " ~S" (nth x(car lista)))
 (scoresa x  (cdr lista) nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun scora (x n lista nom-fichier)
  (append  
   (format nom-fichier  "~%i~S"n)
   (scoresa x  lista nom-fichier)))
;;;;;;;;;;;;;;;;;;;;;;;;
(defun scoreson ( j n lista nom-fichier)
   (if (> j (-(length (car lista))1))nil  
(append    
    (scora j n lista nom-fichier)   
    (scoreson (+ 1 j) n lista  nom-fichier))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun sco (n lista nom-fichier)
 (append (scoreson 0 n lista nom-fichier)
         (format nom-fichier "~%e")))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DEFINIZIONE ENVELOPE ORC PER SCORE COMPLESSO
(defun pSScopy (list1 list2 nom-fichier)
  (if (null list1) NIL
      (if (null list2) NIL
          (append(list(format nom-fichier "~8F*p4,"(car list1))
                      (format nom-fichier "~8F*p5,"(car list2))
                      (pSScopy (cdr list1)(cdr list2) nom-fichier))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun pline (k n q list1 list2  nom-fichier )
  (let((listx(interplus0  list1 0 1)))
    (let((listy(kqinterp0 list2 0 1)))
    (if (null listx) nil
        (if (null listy) nil
          (append(list 
                    (format nom-fichier "~%~S~S ~S ~8F*p4,"k n q (car listx))           
                    (format nom-fichier "~8F*p5,"(car listy))
                    (pSScopy (cdr listx)(cdr listy) nom-fichier)
                    (format nom-fichier "~8F*p4"(car(reverse listx)))             
                    )))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun plinend (k n q list1   list2  nom-fichier )
  (let((listx(interplus0  list1 0 1)))
    (let((listy(kqinterp0 list2 0 1)))
    (if (null listx) nil
        (if (null listy) nil
          (append(list 
                    (format nom-fichier "~%~S~S ~S ~8F*p4,"k n q (car listx))           
                    (format nom-fichier "~8F*p5,"(car listy))
                    (SScopy (cdr listx)(cdr listy) nom-fichier)
                    (format nom-fichier "~8F*p4, .01,0.00001"(car(reverse listx)))             
                    )))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun plinex (k n q p1 p2 list1 list2  nom-fichier )
  (let((listx(interplus0  list1 0 1)))
    (let((listy(kqinterp0 list2 0 1)))
    (if (null listx) nil
        (if (null listy) nil
          (append(list 
                    (format nom-fichier "~%~S~S ~S ~8F*p~S,"k n q (car listx)p1)           
                    (format nom-fichier "~8F*p~S,"(car listy) p2)
                    (pSScopy (cdr listx)(cdr listy) nom-fichier)
                    (format nom-fichier "~8F*p~S"(car(reverse listx))p1)             
                    )))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;ESEMPIO
;(with-open-file (nom-fichier "Cursus FX1:Users:FR:getStarted:7sco.cso" 
;                            :direction :output :if-exists :overwrite 
;                            :if-does-not-exist :create)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;(SCO
;;;-P1: numero instr 
;          1         '(   
;;;-P2: attacco                                   
;    (jinterpol 0 7 1.5 1)                      
;;;-P3: durata
;     (idem  12 9)
;;;-P4: ratio amp                               
;       (jinterpol 1 7 1 .1)
;;;-P5: ratio time   
;      (jinterpol 1 7 1 .6)
;;;-evalue.
; )nom-fichier))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;FREQ E BAND VOCALI MASCHILI
(setq fa1 '(609 1000 2450 2700))
(setq fe  '(400 1700 2300 2900))
(setq fi  '(238 1741 2450 2900))
(setq fo  '(325 700 2550 2850))
(setq fu  '(360 750 2400 2675))
(setq foe '(415 1400 2200 2800))
(setq fa3 '(300 1600 2150 2700))
(setq fa2 '(400 1050 2200 2650))
(setq ba1 '(78 88 123 128))
(setq be  '(64 81 101 119))
(setq bi  '(73 108 123 132))
(setq bo  '(73 80 125 131))
(setq bu  '(51 61 168 184))
(setq boe '(45 64 93 114))
(setq ba3 '(66 93 108 122))
(setq ba2 '(73 90 118 127))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun sumplusx (lista listb)
  (if (null listb ) nil
         (cons (summa  (car listb) lista)
         (sumplusx lista  (cdr  listb)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun sumplusx2 (lista listb)
  (if (null listb ) nil
  (cons (summa (car lista) (car listb))
        (sumplusx2 (cdr lista) (cdr listb)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DISTORSIONI
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun dist(part freq dist)
       (let ((res))
         (dotimes (n part res)
           (setf res (cons (* freq (expt(+ n 1) dist))res)))
           (reverse res)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;LISTA DI SPETTRI DIST SULLO STESSO FOND E  COEFF. DIFFERENTI
(defun distplus (part freq lista)
(if (null lista)nil
 (cons   (dist part freq (car lista))
         (distplus part freq (cdr lista)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;LISTA DI SPETTRI DIST SU DIFFERENTI FOND. E STESSO COEFF.
(defun  distcord (p  list0 dist)
 (if (null list0)nil
     (cons  (dist p (car list0) dist)
            (distcord p (cdr list0) dist))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;LISTA DI SPETTRI DIST SU DIFFERENTI FOND E DIFFERENTI COEFF.
(defun  distcord2 (p  list0 list1)
 (if (null list0)nil
     (cons  (dist p (car list0) (car list1))
            (distcord2 p (cdr list0) (cdr list1)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;A PARTIRE DA UNA LISTA DI FREQ  E DI FOND , ESCE UNA LISTA
;;;DI SPETTRI DIST  NEI QUALI LE FREQ CORRISPONDONO AI
;;;PARZIALI N (LPART) DEGLI SPETTRI DIST SULLE FOND DATE
(defun distcordfond (np lfz lfond lpart)
 (if (null lfz) nil
 (cons (dist np (car lfond) 
        (finddist (car lfz)(car lfond)(car lpart)))
        (distcordfond np (cdr lfz) (cdr lfond) (cdr lpart)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun  distcord2*2 (p  list0 list1 list2 list3)
 (if (null list0)nil
     (cons (append (dist p (car list0) (car list1))
            (dist p (car list2) (car list3)))
            (distcord2*2 p (cdr list0) (cdr list1)(cdr list2) (cdr list3)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;TROVA IL COEFFICENTE DI DISTORSIONE
(defun finddist (freq fond npart)
  (log (/ freq fond) npart))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATO UN ACCORDO, LO INTEGRA IN  SPETTRI DISTORTI 
;;;DI UN FONDAMENTALE DATO ABBASSANDO IL COEFF.DIST.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun goback (np fond coeff)
  (if (< coeff .1) nil
       (cons (dist np fond coeff)
            (goback np fond (- coeff .05)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun brr (i lista x) 
  (if (null lista) nil
  (if (and (< i (* (car lista ) 1.059463)) 
        (> i (* (car lista) 0.94388636)))  x
        (brr i (cdr lista) x ))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun brr2 (listi lista x)
  (if (null listi) nil
      (let ((qq  (brr (car listi) lista x)))
        (if  (not (eql qq x)) nil
             (cons x (brr2 (cdr listi) lista x))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun gogo (listi lista x)
  (nth (- (length listi) 1) (brr2 listi lista x)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun findcoeff (listi lista listx)
(if (null lista) nil
    (cons
     (gogo listi (car lista) (car listx))
     (findcoeff listi (cdr lista) (cdr listx)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun HH ( listi np fond coeff )
  (remove nil (findcoeff listi (goback  np fond coeff)  
                         (goback  np fond coeff))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATO UN ACCORDO, LO INTEGRA IN SPETTRI DISTORTI 
;;;DI UN COEFF.DIST. DATO ABBASSANDO IL FONDAMENTALE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun gobackfond (np fond coeff)
  (if (< fond 27.5) nil
       (cons (dist np fond coeff)
            (gobackfond np  (* fond .94388) coeff))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun hratio ( listi np fond coeff )
  (remove nil (findcoeff listi (gobackfond  np fond coeff)  
                         (gobackfond  np fond coeff))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA D'ACCORDI, LI INTEGRA IN  SPETTRI DISTORTI 
;;;DI UN FONDAMENTALE DATO ABBASSANDO IL COEFF.DIST.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun carhh (listi np fond coeff)
  (car (hh listi np fond coeff)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun multihh (lista np fond coeff)
  (if (null lista) nil
  (cons (carhh (car lista) np fond coeff)
         (multihh (cdr lista) np fond coeff))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA D'ACCORDI, LI INTEGRA IN  SPETTRI DISTORTI 
;;;DI UN FONDAMENTALE DATO ABBASSANDO IL FONDAMENTALE
(defun carhhfond(listi np fond coeff)
  (car (hhfond listi np fond coeff)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun multihhfond (lista np fond coeff)
  (if (null lista) nil
  (cons (carhhfond (car lista) np fond coeff)
         (multihhfond (cdr lista) np fond coeff))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA DI ACCORDI, LI INTEGRA IN  SPETTRI DISTORTI 
;;;DI UN FONDAMENTALE CORRISPONDENTE ALLA NOTA PIU' GRAVE DI 
;;;OGNI ACCORDO, ABBASSANDO IL COEFF.DIST.
(defun contrhh(lista np coeff)
  (if (null lista )nil
      (cons (carhh (car lista) np (first (car lista)) coeff)
            (contrhh (cdr lista) np coeff))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun contr-spectr (lista np coeff)
  (append lista (contrhh lista np coeff)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;TROVA IL COEFF DI DISTORSIONE
;;;DI UNA LISTA D'ACCORDI (PER UN FONDAMENTALE DATO)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun finddistchord (chord fond )
  (log (/ (nth 1 chord) fond) 2))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun findmultidist (lista fond )
  (if (null lista)nil
      (cons (finddistchord (car lista) fond)
            (findmultidist (cdr lista) fond))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun finddist-contr(lista)
  (if (null lista)nil
      (cons (finddistchord (car lista) (first (car lista)))
            (finddist-contr (cdr lista)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;FORNISCE UNA  LISTA DI SPETTRI D'INTERPOLAZIONE TRA UNA 
;;;LISTA DI SPETTRI DATA
(defun listcar (lista)
         (if (null lista) nil
             (cons (car (car lista)) 
                   (listcar (cdr lista)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun interp-contr (Lspectr  etapes coeff)
  (distcord2 (length (car Lspectr))
   (interplus0  (listcar Lspectr) etapes coeff )
   (interplus0 (finddist-contr Lspectr) etapes  coeff)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;MODULAZIONE DI FREQUENZA
;;;ADDIZIONE
(defun fmspectrum1 (port mod index)
  (let ((l nil))
    (do ((i index (1- i)))
        ((<= i 0)l)
      (setq l (cons (+ port (* mod i))l)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;SOTTRAZIONE
(defun fmspectrum2 (port mod index)
  (let ((l nil))
    (do ((i index (1- i)))
        ((<= i 0)l)
      (setq l (cons (- port (* mod i))l)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;RENDE POSITIVI I VALORI NEGATIVI DI UNA LISTA
(defun rempl (lista)
 (if (null lista) nil
(cons 
  (if (> 0 (car lista))  
    (* (car lista) -1)
     (car lista))
  (rempl (cdr lista)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;     
;;;ADD.+SOTTR.con REMPL.(formula base)
(defun fm (port mod index)
  (append (fmspectrum1 port mod index) 
          (remove 0 (rempl (fmspectrum2 port mod index)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;FM con ratio
(defun fmr (port ratio index)
  (append (fmspectrum1 port (* port ratio) index) 
          (remove 0 (rempl (fmspectrum2 port (* port ratio) index)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATO UN ACCORDO, LO INTEGRA IN  SPETTRI FM
;;;CON PORT FISSA E ABBASSANDO IL RATIO
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun gobackratio (port ratio index)
  (if (< ratio .1) nil
       (cons (fmr port ratio index)
            (gobackratio port (- ratio .05) index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun HHratio ( listi port ratio index )
  (remove nil (findcoeff listi (gobackratio  port ratio index)  
                         (gobackratio  port ratio index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;TROVA IL RATIO FM
;;;DI UNA LISTA DI SPETTRI FM (PER UNA PORTANTE DATA)
(defun findratio (lista port)
 (/ (- (car lista) port) port))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun findmultiratio (lista port)
  (if (null lista)nil
      (cons (findratio (car lista ) port)
            (findmultiratio (cdr lista ) port))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATO UN ACCORDO, LO INTEGRA IN  SPETTRI FM
;;;CON RATIO FISSO E ABBASSANDO LA PORT
(defun gobackport (port ratio index)
  (if (< port 27.5) nil
       (cons  (fmr port ratio index)
            (gobackport (* port .94388) ratio  index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun HHport ( listi port ratio index )
  (remove nil (findcoeff listi (gobackport  port ratio index)  
                         (gobackport  port ratio index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;TROVA LA PORT
;;;DI UNA LISTA DI SPETTRI 
(defun findport (lista )
  (- (car lista)  (/ (- (car lista) (nth 1 lista)) -1)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun findmulport (lista)
  (if (null lista)nil
      (cons (findport (car lista ) )
            (findmulport (cdr lista )))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA D'ACCORDI, LI INTEGRA IN  SPETTRI FM
;;;CON PORT FISSA E ABBASSANDO IL RATIO 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun carhhratio (listi port ratio index)
  (car (hhratio listi port ratio index)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun multihhratio (lista port ratio index)
  (if (null lista) nil
      (cons (carhhratio (car lista) port ratio index)
         (multihhratio (cdr lista) port ratio index))))
;;;DATA UNA LISTA D'ACCORDI, LI INTEGRA IN  SPETTRI FM
;;;CON RATIO FISSO E ABBASSANDO LA PORT
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun carhhport (listi port ratio index)
  (car (hhport listi port ratio index)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun multihhport (lista port ratio index)
  (if (null lista) nil
      (cons (carhhport(car lista) port ratio index)
         (multihhport (cdr lista) port ratio index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA DI ACCORDI, LI INTEGRA IN  SPETTRI FM 
;;;DI UNA PORT CORRISPONDENTE ALLA NOTA X(NPORT) DI 
;;;OGNI ACCORDO, ABBASSANDO IL RATIO
(defun contrhhratio (lista nport ratio index)
  (if (null lista )nil
      (cons (carhhratio (car lista) (nth nport (car lista)) ratio index )
            (contrhhratio (cdr lista) nport ratio index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun contr-fm (lista nport ratio index)
  (append lista (contrhhratio lista nport ratio index)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATO UN ACCORDO, LO INTEGRA IN  SPETTRI FM
;;;CON PORT FISSA E ABBASSANDO IL RATIO1 FINO AL RATIO2
(defun gobackratio2 (port ratio1 ratio2 index)
  (if (< ratio1 ratio2) nil
       (cons (fmr port ratio1 index)
            (gobackratio2 port (- ratio1 .03) ratio2 index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun HHratio2 ( listi port ratio1 ratio2 index )
  (remove nil (findcoeff listi (gobackratio2  port ratio1 ratio2 index)  
                         (gobackratio2  port ratio1 ratio2 index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA DI INTERVALLI, LI INTEGRA IN SPETTRI DISTORTI
;;;ABBASSANDO IL COEFF.; E' POSSIBILE DEFINIRE QUANTI DEGLI INTERVALLI 
;;;DELLA LISTA DEVONO ESSERE OBBLIGATORIAMENTE PRESENTI NELLO SPETTRO (NI) 
;;;E IN QUALE DENSITA' MINIMA (NN ) RISPETTO AL NUMERO COMPLESSIVO 
;;;DEGLI INTERVALLI DELLO SPETTRO
(defun popo (i lista x)
(if (null (cdr lista)) nil
    (if (and (< i (* (/ (nth 1 lista) (nth 0 lista)) 1.0293022))
         (> i (* (/ (nth 1 lista) (nth 0 lista)) .97153834))) 
       (cons x (popo i (cdr lista) x ))
       (cons nil (popo i (cdr lista) x )))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun popo2 (listi lista )
  (if (null listi) nil
        (cons 
         (if
          (< (length (remove nil (popo (car listi) lista 'ok))) 1) nil
         lista)
           (popo2 (cdr listi) lista ))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun popo2bis (listi lista )
  (if (null listi) nil
        (append (popo (car listi) lista 'ok)
             (popo2bis (cdr listi) lista ))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun popo3/a (listi lista ni)
  (let (( gg (popo2 listi lista )))     
      (if (<= ni (length (remove nil gg)))
        lista
        nil)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun popo3/b (listi  lista ni)
  (if (null lista) nil
   (remove nil   (cons
       (popo3/a listi (car lista) ni)
                        (popo3/b listi (cdr lista) ni)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun YY1 ( listi ni np fond coeff )
 (remove nil (popo3/b listi (goback  np fond coeff)  
                         ni)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun popo3 (listi lista ni)
    (let (( gg (popo2bis listi lista )))     
      (if (<= ni (length (remove nil gg)))
        lista
        nil)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun popo4 (listi lista ni)
(if (null lista) nil
    (cons
     (popo3 listi  (car lista) ni)
     (popo4 listi (cdr lista) ni))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun YY2 (listi ni nn np fond coeff)
 (remove nil (if (null (YY1 listi ni np fond coeff)) nil
  (popo4 listi (YY1 listi ni np fond coeff) nn))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA DI INTERVALLI, LI INTEGRA IN SPETTRI FM
;;;ABBASSANDO IL RATIO; E' POSSIBILE DEFINIRE QUANTI DEGLI INTERVALLI 
;;;DELLA LISTA DEVONO ESSERE OBBLIGATORIAMENTE PRESENTI NELLO SPETTRO (NI) 
;;;E IN QUALE DENSITA' MINIMA (NN ) RISPETTO AL NUMERO COMPLESSIVO 
;;;DEGLI INTERVALLI DELLO SPETTRO (INDEX * 2)

(defun fmr/sort (port ratio index)
(sort (append  (cons port (fmspectrum1 port (* port ratio) index))
       (remove 0 (rempl (fmspectrum2 port (* port ratio) index)))) '<))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun gobackratio/sort (port ratio index)
  (if (< ratio .1) nil
       (cons (fmr/sort port ratio index)
            (gobackratio/sort port (- ratio .01) index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun YY1ratio( listi ni port ratio index )
 (remove nil (popo3/b listi (gobackratio/sort port ratio index)  
                         ni)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun YY2ratio (listi ni nn port ratio index)
 (remove nil (if (null (YY1ratio listi ni port ratio index)) nil
  (popo4 listi (YY1ratio listi ni port ratio index) nn))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(setq 2mi '1.059)
(setq 2ma '1.122)
(setq 3mi '1.189)
(setq 3ma '1.260)
(setq 4j  '1.335)
(setq 4ex '1.414)
(setq 5j  '1.498)
(setq 6mi '1.587)
(setq 6ma '1.682)
(setq 7mi '1.782)
(setq 7ma '1.888)
(setq 8j  '2)
(setq 9mi '2.119)
(setq 9ma '2.245)
(setq 10mi '2.378)
;;;DATA UNA LISTA DI LISTE D'INTERVALLI, LI INTEGRA IN SPETTRI DIST
;;;ABBASSANDO IL COEFF; E' POSSIBILE DEFINIRE QUANTI DEGLI INTERVALLI 
;;;DELLA LISTA DEVONO ESSERE OBBLIGATORIAMENTE PRESENTI NELLO SPETTRO (NI) 
;;;E IN QUALE DENSITA' MINIMA (NN ) RISPETTO AL NUMERO COMPLESSIVO 
;;;DEGLI INTERVALLI DELLO SPETTRO (NP)
(defun caryy2 (listi ni nn np fond coeff)
(car (yy2 listi ni nn np fond coeff)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun multiyy2 (lista ni nn np fond coeff)
  (if (null lista) nil
      (cons (caryy2 (car lista) ni nn np fond coeff)
         (multiyy2 (cdr lista) ni nn np fond coeff))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;CALCOLA L'INTERPOLAZIONE TRA DUE O PIU' SPETTRI DIST
;;;IN BASE AD UNA LISTA D'INTERVALLI. 
;;;E' POSSIBILE DEFINIRE QUANTI DEGLI INTERVALLI 
;;;DELLA LISTA DEVONO ESSERE OBBLIGATORIAMENTE PRESENTI NELLO SPETTRO (NI) 
;;;E IN QUALE DENSITA' MINIMA (NN ) RISPETTO AL NUMERO COMPLESSIVO 
;;;DEGLI INTERVALLI DELLO SPETTRO, E QUANTE TAPPE INTERMEDIARIE DELL'INT
;;;DEVONO RISPONDERE A QUESTE CARATTERISTICHE AFFINCHE' L'INTERP VENGA
;;;EDITA (gogackplus + superxxx)
(defun gobackplus (Lspectr etapes coeff)
  (if (< coeff .1) nil
       (cons (interp-contr Lspectr etapes coeff)
            (gobackplus  Lspectr etapes (- coeff .05)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun xxx (listi listone  ni nn )
  (let ((ww (remove nil (popo3/b listi (car listone) ni))))
   (remove nil (if (null ww) nil
        (popo4 listi ww nn)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun selectxxx (listi listone ni nn nr)
  (let ((qqq ( xxx listi listone ni nn)))
    (if (>=  (length qqq)  nr) qqq
        nil)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun superxxx (listi iperlista ni nn nr)
  (if (null iperlista) nil
   (remove nil (append (selectxxx listi iperlista ni nn nr)
            (superxxx listi (cdr iperlista) ni nn nr)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun interp-list-interval (Lspectr etapes coeff listi ni nn nr)
  (superxxx  listi (gobackplus lspectr etapes coeff) ni nn nr))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA DI LISTE D'INTERVALLI, LI INTEGRA IN SPETTRI FM
;;;ABBASSANDO IL RATIO; E' POSSIBILE DEFINIRE QUANTI DEGLI INTERVALLI 
;;;DELLA LISTA DEVONO ESSERE OBBLIGATORIAMENTE PRESENTI NELLO SPETTRO (NI) 
;;;E IN QUALE DENSITA' MINIMA (NN ) RISPETTO AL NUMERO COMPLESSIVO 
;;;DEGLI INTERVALLI DELLO SPETTRO (INDEX * 2)
(defun caryy2 (listi ni nn np fond coeff)
(car (yy2 listi ni nn np fond coeff)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun caryy2ratio (listi ni nn port ratio index)
(car (yy2ratio listi ni nn port ratio index)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun multiyy2ratio (lista ni nn port ratio index)
  (if (null lista) nil
      (cons (caryy2ratio (car lista) ni nn port ratio index)
         (multiyy2ratio (cdr lista) ni nn port ratio index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;TROVA IL RATIO FM DI UNO SPETTRO FM I CUI PARZIALI
;;;SONO IN ORDINE DI FREQUENZA CRESCENTE
(defun findratio/sort (lista port)
  (let ((listar (remove port lista)))
  ( / (/ ( - (car(reverse listar)) port) (/ (- (length lista)1) 2))
      port )))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;TROVA IL RATIO FM DI UNA LISTA DI SPETTRI FM I CUI PARZIALI
;;;SONO IN ORDINE DI FREQUENZA CRESCENTE
(defun fmulratiosort (lista port)
  (if (null lista)nil
      (cons (findratio/sort (car lista ) port)
            (fmulratiosort (cdr lista ) port))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;CALCOLA L'INTERPOLAZIONE TRA DUE O PIU' SPETTRI FM
;;;IN BASE AD UNA LISTA D'INTERVALLI. 
;;;E' POSSIBILE DEFINIRE QUANTI DEGLI INTERVALLI 
;;;DELLA LISTA DEVONO ESSERE OBBLIGATORIAMENTE PRESENTI NELLO SPETTRO (NI) 
;;;E IN QUALE DENSITA' MINIMA (NN ) RISPETTO AL NUMERO COMPLESSIVO 
;;;DEGLI INTERVALLI DELLO SPETTRO, E QUANTE TAPPE INTERMEDIARIE DELL'INT
;;;DEVONO RISPONDERE A QUESTE CARATTERISTICHE AFFINCHE' L'INTERP VENGA
;;;EDITA (gobackratioplus + superxxx)
(defun many-fmr/sort (port list1 index)
  (if (null list1) nil
      (cons (fmr/sort port (car list1) index)
            (many-fmr/sort port (cdr list1) index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun interp-fmr (Lspectr port etapes coeff)
  (many-fmr/sort port
   (interplus0 (fmulratiosort  Lspectr port) etapes coeff)
   (/(- (length (car lspectr)) 1) 2)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun gobackratioplus (Lspectr port etapes coeff)
  (if (< coeff .1) nil
       (cons (interp-fmr Lspectr port etapes coeff)
            (gobackratioplus  Lspectr port etapes (- coeff .05)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun interpFM-list-interval 
       (Lspectr port etapes coeff listi ni nn nr)
  (superxxx listi (gobackratioplus Lspectr port etapes coeff) ni nn nr))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA DI INTERVALLI, LI TROVA ALL'INTERNO DI UNO SPETTRO,
;;;NELL'ORDINE STABILITO DALLA LISTA,E LI FA APPARIRE CANCELLANDO
;;;LE NOTE DELLO SPETTRO ESTRANEE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kul (i f0 lista )
(if (null lista) nil
    (if (and (< i (* (/ (car lista) f0) 1.0293022))
         (> i (* (/ (car lista) f0) .97153834)))
       (list f0  (car lista ))
       (kul i f0 (cdr lista)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kul8me (i f0 lista )
(if (null lista) nil
    (if (and (< i (* (/ (car lista) f0) 1.015))
         (> i (* (/ (car lista) f0) .985)))
       (list f0  (car lista ))
       (kul i f0 (cdr lista)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun removeplus (lista listb)
        (let (( zzz(remove (car lista) listb)))     
          (if (null lista) zzz
             (removeplus (cdr lista) zzz))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun only+ (n lista)
(if (null  lista) nil
    (if (>= (car lista) n) lista
        (only+ n (remove (car lista) lista)))))
        
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun kul2 (i lista)
  (if (null lista) nil
  (if ( null (kul i (car lista) (cdr lista)))
    (kul2 i (cdr lista))
          (kul i (car lista) (cdr lista)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;        
(defun kkk/a (listk lista)
  (if (null listk) nil
       (let ((may (kul (car listk) (car lista) (cdr lista)))) 
        (if (null may) nil
         (remove-duplicates   (append may (kkk/a (cdr listk) 
                             (only+ (nth 1  may) lista))))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cherche-int0 (listint listfreq)
  (if (null  listfreq ) nil
  (let ((bobo (kul2 (car listint)  listfreq)))
    (let ((momo (kkk/a (cdr listint) (only+ (nth 1 bobo) listfreq))))
    (if (null momo) (cherche-int0 listint ( cdr listfreq))
    (remove-duplicates (append bobo momo)
          ))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cherche-int (listint listfreq)
  (if (null listfreq) nil
      (if (= (- (length (cherche-int0 listint listfreq)) 1)
             (length listint))
        (cherche-int0 listint listfreq)
        (cherche-int listint (cdr listfreq)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA DI INTERVALLI, LI TROVA ALL'INTERNO DI UNA LISTA DI
;;;SPETTRI, NELL'ORDINE STABILITO DALLA LISTA, E LI FA APPARIRE 
;;;CANCELLANDO LE NOTE DELLO SPETTRO ESTRANEE AGLI INTERVALLI
(defun multicherche (listint listspectr)
  (if (null listspectr) nil
      (cons (cherche-int listint (car listspectr))
              (multicherche listint (cdr listspectr)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA DI LISTE D'INTERVALLI, LI TROVA ALL'INTERNO DI UNO
;;;SPETTRO, NELL'ORDINE STABILITO DALLA LISTA, E LI FA APPARIRE 
;;;CANCELLANDO LE NOTE DELLO SPETTRO ESTRANEE AGLI INTERVALLI
(defun multicherche1 (listinterplus listfreq)
  (if (null listinterplus) nil
      (cons (cherche-int0 (car listinterplus) listfreq)
              (multicherche1 (cdr listinterplus) listfreq))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA DI LISTE D'INTERVALLI, LI TROVA ALL'INTERNO DI UNA LISTA DI
;;;SPETTRI, NELL'ORDINE STABILITO DALLA LISTA, E LI FA APPARIRE 
;;;CANCELLANDO LE NOTE DELLO SPETTRO ESTRANEE AGLI INTERVALLI
(defun multicherche2 (listinterplus listspectr)
  (if (null listinterplus) nil
      (cons (cherche-int (car listinterplus) (car listspectr))
              (multicherche2 (cdr listinterplus) (cdr listspectr)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA DI INTERVALLI, LI TROVA IN UNO SPETTRO AGGIUNGENDO
;;;DELLE FREQUENZE, SE NECESSARIO, TRA UN PARZIALE E L'ALTRO
(defun quasi4 (i f0 f1)
       (if (and (< i (* (/ f1 f0) 1.0293022))
         (> i (* (/ f1 f0) .97153834)))
         (list f0 f1) nil))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun quasi4plus (lista f0 f1)
  (if (null lista) nil
     (if (null  (quasi4 (car lista) f0 f1))
       (quasi4plus (cdr lista) f0 f1)
       (list f0 f1))))
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun coco ( f0 lista)
    (cons f0
    (let ((toto nil))
      (let ((add f0))
        (dolist  (x lista )
          (setq add  (* add x ))  
          (push add toto ))) (reverse toto))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun densdens (lista f0 f1 www)
  (let ((zzz (cons 1 lista)))
  (if (null www) nil
      (cons (car www )
      (if (null (quasi4plus   zzz (car www) f1))
      (densdens (cdr zzz) f0 f1 (cdr www))
      nil)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun densdens1 (lista f0 f1) 
   (let ((byby (densdens lista f0 f1 (coco f0 lista))))
         (if (null (quasi4plus lista
                               (nth (- (length byby)1) byby)
                               f1)) nil
           (append byby (cons f1 nil)))))         
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun alldensdens (lista f0 f1) 
   (let ((byby (densdens lista f0 f1 (coco f0 lista))))
         (if (null (quasi4plus lista
                               (nth (- (length byby)1) byby)
                               f1)) (list f0 f1)
           (append byby (cons f1 nil)))))   
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;ESCONO SOLO GLI INTERVALLI VOLUTI
(defun densifier (listint listfreq)
  (if (null (cdr listfreq)) nil
  (remove-duplicates 
   (append  (densdens1 listint (nth 0 listfreq) (nth 1 listfreq))
      (densifier listint (cdr listfreq))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;ESCONO TUTTE LE NOTE DELLO SPETTRO+LE NOTE AGGIUNTE
(defun alldensifier(listint listfreq)
  (if (null (cdr listfreq)) nil
  (remove-duplicates 
   (append  (alldensdens listint (nth 0 listfreq) (nth 1 listfreq))
      (densifier listint (cdr listfreq))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA DI INTERVALLI, LI TROVA IN UNA SERIE DI SPETTRI 
;;;AGGIUNGENDO DELLE FREQUENZE, SE NECESSARIO, TRA UN PARZIALE E L'ALTRO
;;;ESCONO SOLO GLI INTERVALLI VOLUTI
(defun multidensifier (listint listspectr)
  (if (null listspectr) nil
  (cons (densifier listint (car listspectr))
        (multidensifier listint (cdr listspectr)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA DI INTERVALLI, LI TROVA IN UNA SERIE DI SPETTRI 
;;;AGGIUNGENDO DELLE FREQUENZE, SE NECESSARIO, TRA UN PARZIALE E L'ALTRO
;;;ESCONO TUTTE LE NOTE DELLO SPETTRO+LE NOTE AGGIUNTE
(defun multialldensifier (listint listspectr)
  (if (null listspectr) nil
  (cons (alldensifier listint (car listspectr))
        (multidensifier listint (cdr listspectr)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;FREQUENCY-SHIFTING;PLUS/MINUS: 1 = ADD.,0 = SOTTR.,
;;;10 = ADD. + SOTTR.
(defun freq-shifting (lista plus/minus fz)
  (cond
   ((= plus/minus 1)
   (summa fz lista))
   ((= plus/minus 0)
    (sott fz lista))
   ((= plus/minus 10)
    (append (summa fz lista) (sott fz lista)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun shiftplus (lista plus/minus listfz)
  (if (null listfz) nil
     (cons (freq-shifting lista plus/minus (car listfz))
           (shiftplus lista plus/minus (cdr listfz)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;SHIFTING SU LISTA D'ACCORDI CON LISTA DI FZ
(defun multishift (listchord plus/minus listfz)
 (if (null listchord) nil
  (cons (freq-shifting (car listchord) plus/minus (car listfz))
  (multishift (cdr listchord) plus/minus listfz))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DIST DI SOLO UNA PORZIONE DELLO SPETTRO,ENTRO NMIN E NMAX
(defun exptplus (freq listb dist)
                       (if (null listb)nil
    (cons (* freq (expt (car listb) dist))
          (exptplus freq (cdr listb) dist))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun selectdist (np freq nmin nmax dist)
(let ((bigolo 
  (summa (- nmin 1) (spectrum  1 1 (- (+ nmax 1) nmin)))))
  (sort
  (append (exptplus freq bigolo dist)
   (removeplus (molt bigolo freq) (spectrum freq 1 np))) '<)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun selectonlydist (freq nmin nmax dist)
  (let ((bigolo 
  (summa (- nmin 1) (spectrum  1 1 (- (+ nmax 1) nmin)))))
   (exptplus freq bigolo dist)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA DI LISTE DI FZ LE INTEGRA IN SPETTRI
;;;DISTORTI SULLO STESSO FOND
(defun segmHH ( listseg np fond coeff)
  (if (null listseg) nil
  (append(cons (car listseg)(hh (car listseg) np fond coeff))
        (segmHH (cdr listseg) np fond coeff))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun nthplus (lista listb)
  (if (null lista) nil
     (cons (nth (car lista) listb)
     (nthplus (cdr lista) listb))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA DI LISTE DI FZ LE INTEGRA IN SPETTRI
;;;FM SULLA STESSA PORT  
(defun segmHHratio ( listseg port ratio index)
  (if (null listseg) nil
  (append(cons (car listseg)(hhratio (car listseg) port ratio index))
        (segmHHratio (cdr listseg) port ratio index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DATA UNA LISTA DI FZ E LA SEGMENTAZIONE IN INSIEMI, 
;;;LI INTEGRA  IN SPETTRI DISTORTI SULLO STESSO FOND
(defun segm-nthHH ( listfreq listnth  np fond coeff)
  (if (null listnth) nil
  (append(cons (nthplus (sott 1 (car listnth)) listfreq)
          (hh (nthplus (sott 1 (car listnth)) listfreq) np fond coeff))
        (segm-nthHH listfreq (cdr listnth) np fond coeff))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DIVIDE L'ACCORDO IN SEGMENTI
(defun dividcord (listfreq listnth)
  (if (null listnth) nil
  (cons (nthplus (sott 1 (car listnth)) listfreq)
        (dividcord listfreq (cdr listnth)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;TRASFORMA UN LISTA DI FZ IN UNA LISTA D'INTERVALLI
(defun cord-int (lista)
(if ( null (cdr lista)) nil
    (cons (/ (nth 1 lista) (nth 0 lista))
          (cord-int (cdr lista)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;TRASFORMA UN LISTA DI LISTE DI FZ 
;;;IN UNA LISTA DI LISTE D'INTERVALLI
(defun cord-intplus (listspectr)
  (if (null listspectr) nil
    (cons  (cord-int (car listspectr))
           (cord-intplus (cdr listspectr)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;FMR SU DIFFERENTI PORT E RATIOS
(defun fmrbis (port ratio index)
 (cons port (append  (fmspectrum1 port (* port ratio) index) 
          (remove 0 (rempl (fmspectrum2 port (* port ratio) index))))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun fmrratioplus (port listratio index)
  (if (null listratio) nil
  (cons (fmrbis port (car listratio) index) 
          (fmrratioplus port (cdr listratio) index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun fmrportplus (listport ratio index)
  (if (null listport) nil
  (cons (fmrbis (car listport)  ratio index) 
          (fmrportplus (cdr listport) ratio index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun fmrplusplus (listport listratio index)
 (if (null listratio) nil
  (cons (fmrbis (car listport)  (car listratio) index) 
          (fmrplusplus (cdr listport) (cdr listratio) index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun fmmodplus (port listmod index)
  (if (null listmod) nil
  (cons (fm port (car listmod) index) 
          (fmmodplus port (cdr listmod) index))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DISTORCE UN AGGREGATO DI FREQUENZE
(defun deform (list dist)
  (if (null list) nil
   (cons (expt (car list) dist)
   (deform (cdr list) dist))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun deformplus  (listfz  listdist)
  (if (null listdist) nil
      (cons (deform listfz  (car listdist))
            (deformplus listfz (cdr listdist)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
